 ; Ŀ
 ;   Gremp - kill all empty groups in the drawing.                         
 ;   Copyright 2000 by Rocket Software                                     
 ;   Caution: on drawings with a lot of groups (the drawing which          
 ;   prompted this warning contained 37,000) this may run very slowly.     
 ;   Technology: you have it, you use it.  Even if you don't want to.      
 ; 

 ; Ŀ
 ;   Subroutine Grex - kill an empty groups.                               
 ;   Takes two arguments, a group ename ad the group dictionary.           
 ; 
 (DEFUN GREX (grnam grdict / namlst grdat asoc70)
 ; Ŀ
 ;   Get the Group data.                                                   
 ; 
  (setq namlst (member (cons 3 grnam) grdict))
  (setq grdat (entget (cdadr namlst)))
 ; Ŀ
 ;   The 70 group in the Group definition supposedly has a value of        
 ;   either 0 = named or 1 = unnamed.                                      
 ;   However, of two groups tested, the one with a value of (70 . 0)       
 ;   could be exploded, the (70 . 3) one couldn't.  Auditing doesn't fix   
 ;   this problem and the group can't be purged.  It has no members.       
 ;   So try to fix it.                                                     
 ; 
  (if (= (cdr (setq asoc70 (assoc 70 grdat))) 3)
      (entmod (subst (cons 70 0) asoc70 grdat)))
 ; Ŀ
 ;   Explode the Group.                                                    
 ; 
  (command ".-group" "explode" grnam)
 (princ))
 ; Ŀ
 ;   Subroutine Grex end.                                                  
 ; 

 ; Ŀ
 ;   Gremp.                                                                
 ; 
 (DEFUN C:GREMP (/ grdict lenstr num count sub grentt subnum grsub)
 ; Ŀ
 ;   Grdict is the group dictionary - a list of all groups in the drawing  
 ;   and names: (various_stuff (3 . "Group_name") (350 . <Ename>)...)      
 ;   The last two sublists are repeated for each group.                    
 ; 
  (setq grdict (dictsearch (namedobjdict) "acad_group"))
  (setq lenstr (strcat "/" (itoa (length grdict))))
  (setq num 0)
  (setq count 0)
 ; Ŀ
 ;   Step through the dictionary list looking for group names and enames.  
 ; 
  (while (setq sub (nth num grdict))
         (grtext -2 (strcat (itoa (setq num (1+ num))) lenstr))
 ; Ŀ
 ;   If the sublist is a name, print it and increment the counter.         
 ; 
         (cond ((= (car sub) 3)
                (prompt (setq grnam (cdr sub)))
                (setq count (1+ count)))
 ; Ŀ
 ;   If the sublist is an ename (350), get the entity (group) list, which  
 ;   contains the ename for each entity in the group as a 340 list.        
 ;   So highlight it.                                                      
 ; 
               ((= (car sub) 350)
                (setq grentt (entget (cdr sub)))
 ; Ŀ
 ;   If the there are no 340 sublists then the group is empty, so          
 ;   explode it.                                                           
 ; 
                (if (null (assoc 340 grentt))
                    (progn
                         (prompt "\t*No Members.*\n")
                         (grex grnam grdict))
                    (prompt "\n"))
                (setq subnum 0)
                (while (setq grsub (nth subnum grentt))
                       (setq subnum (1+ subnum))
                       (if (= (car grsub) 340)
                           (redraw (cdr grsub) 3))))))
  (write-line (strcat "\nGroups: " (itoa count)))
 (princ))